# WorldViz  2002 =================================================
#
#	Displays a spinning sphere or necker cube inside the gallery.
#	User can change the direction of the spin.
#
#Commands:
#	' ' - Toggle between sphere and necker cube
#	->	- Spin objects to the right
#	<-	- Spin objects to the left
#	'r'	- Reset head tracking
#	'q'	- Quit
#
#==================================================================


import viz
import string
import math
import whrandom

viz.go(viz.PROMPT)

#Add class that pings with demo id
import sys
sys.path.append('../')
import Watcher
watch = Watcher.Watch(8)

if viz.get(viz.TRACKER):
	v = viz.add('intersense.dls')
	viz.tracker()
	v.reset()
	tracking = 1
else:
	tracking = 0

EYE = 1.8
Z = 1.5

SPHERE = 1

NUM_DOTS	= 350
RADIUS		= .5

angle 	= 0
SPEED 	= 1
direction = 1
hideNecker = 1

#Add the gallery
room = viz.add('gallery.wrl')
room.appearance(viz.TEXMIPMAP|viz.TRANSPARENCY)

#Add the necker cube
necker = viz.add('necker.wrl')
necker.translate(0,EYE,Z)
necker.scale(3,3,3)
necker.curtain(1)

#Build sphere
viz.startlayer(viz.POINTS)
viz.vertexcolor(1,1,1)
viz.pointsize(2)
for i in range(0, NUM_DOTS):
	x = whrandom.random() - 0.5
	y = whrandom.random() - 0.5
	z = whrandom.random() - 0.5
	length = math.sqrt(x*x + y*y + z*z)
	x = x / length * RADIUS
	y = y / length * RADIUS + EYE
	z = z / length * RADIUS
	viz.vertex(x, y, z)
viz.endlayer()


###############################################
def mytimer(num):
	global angle
		
	#Rotate the sphere and necker cube
	viz.reset(viz.WORLD, 1)
	viz.translate(viz.WORLD, SPHERE, 0, 0, Z)
	viz.rotate(viz.WORLD, SPHERE, viz.YAXIS, angle)
	necker.rotate(0,1,0,angle)
	#update rotation
	angle = angle + (SPEED*direction)
	
###############################################
def mykeyboard(key):
	global direction
	global hideNecker

	key = string.lower(key)	

	#Toggle between showing sphere and necker cube
	if key == ' ':
		hideNecker = not hideNecker
		necker.curtain(hideNecker)
		viz.curtain(not hideNecker,viz.WORLD,SPHERE)
		return

	#Change direction
	if key == viz.KEY_LEFT:
		direction = 1
		return
		
	#Change direction
	if key == viz.KEY_RIGHT:
		direction = -1
		return
		
	#Reset tracking
	if key == 'r' and tracking:
		v.reset()
		return

	#Quit
	if key=='q':
		viz.quit()
		return

#Move viewer back and up
viz.translate(viz.HEAD_POS,0,0,-2)
viz.eyeheight(EYE)

#Set up callback events
viz.callback(viz.KEYBOARD_EVENT, mykeyboard)
viz.callback(viz.KEYBOARDX_EVENT, mykeyboard)
viz.callback(viz.TIMER_EVENT, mytimer)
viz.starttimer(0, 0.01, -1)

#Override to allow transparency in gallery
viz.override()
